function norm_logl = norm_logl(data, par, cop_opt, dx, dz, kk)

y = data(:,1);
d = data(:,2);
x = data(:,3:2+dx);
z = data(:,(3+dx):(2+dx+dz));

alpha = par(1:dx) ;
gamma = par(dx+1:dx+dz) ;
beta = par(dx+dz+1:dx+dz+dx) ;
delta = par(dx+dz+dx+1) ;
rho = par(kk) ;

mue = par(kk+1) ;
muv = par(kk+2) ;
sigmae = par(kk+3) ;
sigmav = par(kk+4) ;


% Choose bivariate distribution here
if cop_opt == 0
    copula = @(u1,u2,dep)copulacdf('Gaussian',[u1,u2],[1,dep;dep,1]);
    %copula = @(u1,u2,rho)normcop(u1,u2,rho);
elseif cop_opt == 2
    copula = @(u1,u2,dep)copulacdf('Frank',[u1,u2],dep);
elseif cop_opt == 3
    copula = @(u1,u2,dep)copulacdf('Clayton',[u1,u2],dep);
elseif cop_opt == 5
    copula = @(u1,u2,dep)copulacdf('Gumbel',[u1,u2],dep);
end



reduce_index = ((x*alpha + z*gamma - muv)./sigmav) ;
out0_index = ((x*beta - mue)./sigmae) ;
out1_index = ((x*beta + d*delta -mue) ./ sigmae) ;

s = normcdf(reduce_index, 0, 1) ;
r0 = normcdf(out0_index, 0, 1) ;
r1 = normcdf(out1_index, 0, 1) ;

p11 = copula(r1, s, rho) ;
p10 = r0 - copula(r0,s,rho) ;
p01 = s - copula(r1, s, rho) ;
p00 = 1 - p11 - p10 - p01 ;

p11(p11<=0) = 1e-10 ;
p00(p00<=0) = 1e-10 ;
p10(p10<=0) = 1e-10 ;
p01(p01<=0) = 1e-10 ;

L11 = (y==1).*(d==1).*log(p11);
L10 = (y==1).*(d==0).*log(p10);
L01 = (y==0).*(d==1).*log(p01);
L00 = (y==0).*(d==0).*log(p00);


logL0 = L11 + L10 + L01 + L00;

fprintf('IsNAN=%d ',sum(isnan(logL0)));
logL0_s = logL0(0==isnan(logL0));
logL0_s = logL0_s(0==isinf(logL0_s));
n_s = size(logL0_s,1);

norm_logl = - sum(logL0_s)/n_s; 
